﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

public class CollectionConfiguration : ConfigurationElement
{
    public Vector2 DestinationIconRenderSize { get; private set; }
    public CollectionEasyConfiguration Easy { get; private set; }
    public CollectionMediumConfiguration Medium { get; private set; }
    public CollectionHardConfiguration Hard { get; private set; }

    public CollectionConfiguration() : base("Collection")
    {

    }

    public override bool Parse(XElement configElem)
    {
        try
        {
            DestinationIconRenderSize = configElem.Element("DestinationIconRenderSize").Value.ToVector2();

            //Create our sub-configuration objects
            Easy = new CollectionEasyConfiguration();
            Medium = new CollectionMediumConfiguration();
            Hard = new CollectionHardConfiguration();

            //Let's try to parse all of our sub configurations, passing in the corresponding parent elements
            if (Easy.Parse(configElem.Element("Easy")))
            {
                if (Medium.Parse(configElem.Element("Medium")))
                {
                    if (Hard.Parse(configElem.Element("Hard")))
                    {
                        return true;    //Parsed everything successfully!
                    }

                    else
                    {
                        Debug.LogError("ERROR: Failed to parse collection hard configuration.");
                    }
                }

                else
                {
                    Debug.LogError("ERROR: Failed to parse collection medium configuration.");
                }
            }

            else
            {
                Debug.LogError("ERROR: Failed to parse collection easy configuration.");
            }

            return false;   //We must have failed to parse one of the configurations
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing collection configuration. The exception is: " + ex);
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}
